#include "JalNames.h"

char NewAddress;
char Packet_Identifier;
char Flags1;
#define New_Address_Arrived Flags1.F0
#define Request_is_known    Flags1.F1
#define NO__EUSART_DEBUG

/* USB data moves between the microcontroller core and the USB Serial Interface Engine (SIE) through a memory space
known as the USB RAM. This is a special dual access memory that is mapped into the normal data memory space in
Bank 2 (200h to 2FFh) for a total of 256 bytes:
     <Buffer descriptor0 (Host's OUT)> (4 bytes)
     <Buffer descriptor1 (Host's IN)> (4 bytes)
     <Space for data buffers> (up to 256-8 bytes - ???)
The sections that are being accessed by the SIE should not be accessed by the microcontroller.
    0x200 ... 0x27F : Buffer descriptors (128 bytes total)
    0x280 ... 0x2FF : Buffers for data (128 bytes total)
Buffer descriptor:
   Buffer0:   0x200: BD0STAT      (flags)
              0x201: BD0CNT       (byte count)
              0x202: BD0ADRL      (address within USB RAM - low byte)
              0x203: BD0ADRH      (address within USB RAM - high byte)
   Buffer1:   0x204: BD1STAT
              ... (and so on)
 The BD1STAT register: UOWN=0  DTS         DTSEN   BSTALL  BC9   BC8
                  or: UOWN=1      PID3 PID2 PID1   PID0     BC9   BC8
 Once the UOWN bit is set, any data or control settings previously written there by the user will be overwritten with data from the SIE. */

// Host -> Controller buffer descriptor (BD0)
sfr unsigned short volatile BD0STAT             absolute 0x200;
sfr unsigned short volatile BD0CNT              absolute 0x201;
sfr unsigned short volatile BD0ADRL             absolute 0x202;
sfr unsigned short volatile BD0ADRH             absolute 0x203;
unsigned char BD0_Buf[64] absolute 0x280;  // Buffers should be in USB RAM, please consult datasheet
// Controller->Host  buffer descriptor (BD1)
sfr unsigned short volatile BD1STAT             absolute 0x204;
sfr unsigned short volatile BD1CNT              absolute 0x205;
sfr unsigned short volatile BD1ADRL             absolute 0x206;
sfr unsigned short volatile BD1ADRH             absolute 0x207;
unsigned char BD1_Buf[64] absolute 0x2c0;  // Buffers should be in USB RAM, please consult datasheet

// More info:
// USB FRAME NUMBER REGISTERS  (UFRMH:UFRML)  For the microcontroller, these registers are read-only.
// USB data moves between the microcontroller core and the SIE through a memory space known as the USB RAM.
//     This is a special dual access memory that is mapped into the normal data memory space in Bank 2 (200h to 2FFh) for a total of 256 bytes
// The host signals the USB device to enter the Suspend mode by stopping all USB traffic to that device for more than 3 ms.
// This condition will cause the IDLEIF bit in the UIR register to become set.


// ------------------------------------------------------------------------------------------------------------------------------
//#ifdef EUSART_DEBUG
// blinks with LED
void _blink(int n) {
 int i;
 for (i=0; i<n; i++) {
     PORTC.F5 = 1;
     Delay_ms(200);
     PORTC.F5 = 0;
     Delay_ms(200);
 }
     Delay_ms(400);
}
  // ----------------------------------------------------------
// initialized EUSART module for sending bytes
void Setup_EUSART_Transmitt() {
 char i;
// EUSART: The operation of the EUSART module is controlled through three registers:  Transmit Status and Control (TXSTA)
//  Receive Status and Control (RCSTA),  Baud Rate Control (BAUDCTL); TRIS control bits corresponding to the RX/DT and TX/CK pins should be set to 1.
// TXSTA:   CSRC | TX9 | TXEN | SYNC | SENDB | BRGH | TRMT | TX9D
// RCSTA:   SPEN | RX9 | SREN | CREN | ADDEN | FERR | OERR | RX9D
// BAUDCON: ABDOVF | RCIDL | DTRXP | CKTXP | BRG16 |  | WUE | ABDEN
        TRISB.F7 = input; // RB7, the TX pin
// Set baud rate to 19200 (SPBRGH:SPBRG register pair)
 BAUDCON.BRG16 = 0;       // 8-bit Baud Rate Generator is used (SPBRG)
 TXSTA.BRGH = 0;          // High Baud Rate Select bit: 0 = Low speed
 SPBRG = 38;              // SYNC=0, BRG16=0, BRGH=0 => Baud Rate = FOSC/[64 (n+1)] => n = 48000000/19200/64-1

// The EUSART transmitter is enabled for asynchronous operations by configuring the following three control bits: TXEN = 1, SYNC = 0, SPEN = 1
 TXSTA.SYNC = 0;          // Enable the asynchronous serial port by clearing the SYNC bit...
 RCSTA.SPEN = 1;          // ...and setting the SPEN bit.
 TXSTA.TX9 = 0;           // If 9-bit transmission is desired, set the TX9 control bit.
 BAUDCON.CKTXP = 0;       // Set the CKTXP control bit if inverted transmit data polarity is desired.
 TXSTA.TXEN = 1;          // Enable the transmission by setting the TXEN control bit.
// A transmission is initiated by writing a character to the TXREG register.
  for (i=0; i<255; i++) {
       TXREG = i;
       asm nop;
       while (!PIR1.TXIF) {};
  }
/* The TXIF bit is only clear when the TSR is busy with a character and a new character has been queued for transmission in the TXREG.
The TXIF flag bit is not cleared immediately upon writing TXREG.
TXIF becomes valid in the second instruction cycle following the write execution. */
}
  // ----------------------------------------------------------
char  i;
// sends BD0 buffer to PC via EUSART
void BD0_to_PC() {
            while (!PIR1.TXIF) {};      TXREG = 0x05;
            asm nop; while (!PIR1.TXIF) {};  TXREG = BD0CNT;
            for (i=0; i<BD0CNT; i++) {  asm nop; while (!PIR1.TXIF) {};  TXREG = BD0_Buf[i]; }
            asm nop; while (!PIR1.TXIF) {};      TXREG = 0xFF;
}
//#endif
// ------------------------------------------------------------------------------------------------------------------------------
void Fill_Buffer_Descriptors(){
 //buffer for Endpoint 0
 // The BDnSTAT byte of the BDT should always be the last byte updated when preparing to arm an endpoint;
 BD0CNT = 64; // ; maximum packet size for low-speed peripherals is 8 bytes, for full-speed peripherals it can be 8, 16, 32, or 64 bytes
 BD0ADRH = 0x02;
 BD0ADRL = 0x80; // writebuff
 BD0STAT = 0x80; //0x88; // 10001000
 //
 BD1CNT = 0;//64;
 BD1ADRH = 0x02;
 BD1ADRL = 0xC0; // writebuff
 BD1STAT = 0x00;//0xC8; // 00;// 0x08;  // 00001000
 }
// ------------------------------------------------------------------------------------------------------------------------------
void _Put_Device_Descriptor(){
     BD1STAT.F7 = 0;                             //      BD1
             BD1_Buf[ 0] = 0x12;                 // bLength
             BD1_Buf[ 1] = 0x01;                 // bDescriptorType
             BD1_Buf[ 2] = 0x10; /*.10*/         // bcdUSB (2 bytes);     
             BD1_Buf[ 3] = 0x01; /*1.*/
             //  USB  1.10,     2.0,       ,
             //   GET_DESCRIPTOR  Descriptor Type = Device Qualifier (6)
             BD1_Buf[ 4] = 0xFF; /*VENDOR-SPECIFIC*/      // bDeviceClass
             BD1_Buf[ 5] = 0x00;                          // bDeviceSubClass
             BD1_Buf[ 6] = 0x00;                          // bDeviceProtocol

             BD1_Buf[ 7] = 64;                   // bMaxPacketSize0
             //     ,          
             BD1_Buf[ 8] = 0xD8;                 // idVendor = USB_VENDOR_ID (2 bytes)
             BD1_Buf[ 9] = 0x04;                 // 0x04D8 = Microchip Technology Inc.
             BD1_Buf[10] = 0x01;                 // idProduct = USB_PRODUCT_ID (2 bytes)
             BD1_Buf[11] = 0x00;                 //
             BD1_Buf[12] = 0x00;                 // bcdDevice - Device release number in binary coded decimal (2 bytes)
             BD1_Buf[13] = 0x00;                 //
             BD1_Buf[14] = 0x00;                 // iManufacturer - Index of string descriptor describing manufacturer - set to 0 if no string
             BD1_Buf[15] = 0x00;                 // iProduct - Index of string descriptor describing product - set to 0 if no string
             BD1_Buf[16] = 0x00;                 // iSerialNumber - Index of string descriptor describing device serial number - set to 0 if no string
             BD1_Buf[17] = 0x01;                 // bNumConfigurations - Number of possible configurations

             BD1CNT = BD1_Buf[ 0];
             //  BD1ADRH:BD1ADRL             
             BD1STAT = 0xC8; // UOWN | DTS=DATA1 | DTSEN  - the host may want to have correct DATA0/DATA1 bit

}
// ------------------------------------------------------------------------------------------------------------------------------

void _Put_Configuration_Descriptor() {
     BD1STAT.F7 = 0;                             //      BD1
             // Configuration Descriptor (9 ,     __  Interface Descriptor ,  ,  
             BD1_Buf[ 0] = 0x09;                   // bLength             - Descriptor size in bytes
             BD1_Buf[ 1] = 0x02;                   // bDescriptorType     - The constant CONFIGURATION (02h)
             BD1_Buf[ 2] = 18;                     // wTotalLength        - The number of bytes in the configuration descriptor and all of its subordinate descriptors
             BD1_Buf[ 3] = 0;
             BD1_Buf[ 4] = 1;                      // bNumInterfaces      - Number of interfaces in the configuration; Index value of this configuration
             BD1_Buf[ 5] = 0;                      // bConfigurationValue - Identifier for Set Configuration and Get Configuration requests
             BD1_Buf[ 6] = 0;                      // iConfiguration      - Index of string descriptor describing configuration - set to 0 if no string
             BD1_Buf[ 7] = 0x80; /*BUS_POWERED*/   // bmAttributes        - Self/bus power and remote wakeup settings
             BD1_Buf[ 8] = 250;                    // bMaxPower           - Bus power required in units of 2 mA

             // Interface Descriptor (9 )
             BD1_Buf[ 9] = 0x09;                   // bLength - Descriptor size in bytes (09h)
             BD1_Buf[10] = 0x04;                   // bDescriptorType - The constant Interface (04h)
             BD1_Buf[11] = 0;                      // bInterfaceNumber - Number identifying this interface
             BD1_Buf[12] = 0;                      // bAlternateSetting - A number that identifies a descriptor with alternate settings for this bInterfaceNumber.
             BD1_Buf[13] = 0;                      // bNumEndpoint - Number of endpoints supported not counting endpoint zero
             BD1_Buf[14] = 0xFF;/*VENDOR-DEFINED*/ // bInterfaceClass - Class code
             BD1_Buf[15] = 0;                      // bInterfaceSubclass - Subclass code
             BD1_Buf[16] = 0;                      // bInterfaceProtocol - Protocol code
             BD1_Buf[17] = 0;                      // iInterface - Interface string index

             BD1CNT = BD1_Buf[ 2]; // 18 bytes
}
// ------------------------------------------------------------------------------------------------------------------------------
void _Put_StringZero_Descriptor() {
             BD1_Buf[ 0] = 4;                   // bLength             - Size of this descriptor in bytes
             BD1_Buf[ 1] = 0x03;                // bDescriptorType     - The constant STRING (03h)
             BD1_Buf[ 2] = 0x09;                // First LANGID Code (2 bytes)
             BD1_Buf[ 3] = 0x04;                //  0x0409 = English (US)
             
             BD1CNT = BD1_Buf[ 0];
             //  BD1ADRH:BD1ADRL             
             BD1STAT = 0xC8; // UOWN | DTS=DATA1 | DTSEN  - the host may want to have correct DATA0/DATA1 bit
}
// ------------------------------------------------------------------------------------------------------------------------------

void Analyse_SETP_Transaction() {
    
    Request_is_known = 0; // assume unknown
    
    //   SETUP: BD0_Buf[0] = bmRequestType; BD0_Buf[1] = Specific Request
    //     bmRequestType:
    //   bmRequestType.F7 = 1  => Host wants an information from Device
    //   bmRequestType.F7 = 0  => Device wants an information from Host
    //   bits 6:5 Type:       0 = Standard; 1 = Class; 2 = Vendor; 3 = Reserved
    //   bits 4:0 Recipient:  0 = Device;   1 = Interface; 2 = Endpoint; 3 = Other; 4-31 = Reserved

    if  ((BD0_Buf[0] == 0x80) && (BD0_Buf[1] == 6)) {// && (BD0CNT > 0)) {
        //    "GET_DESCRIPTOR": BD0_Buf[0] = 10000000b; BD0_Buf[1] = 6 = GET_DESCRIPTOR
        //      ,   :
        //      BD0_Buf[2] = Descriptor Index
        //      BD0_Buf[3] = Descriptor Type (1: DeviceDescriptor; 2: ConfigurationDescriptor; 6: Device Qualifier
        //  BD0_Buf[4], BD0_Buf[5] = wIndex (   ),
        //  BD0_Buf[6], BD0_Buf[7] = wLength:        DATA Stage (Number of bytes to transfer if there is a data stage)
        if ((BD0_Buf[2]== 0) && (BD0_Buf[3]== 1/*Type="Device"*/)) {
             //         BD1CNT  BD1STAT
             _Put_Device_Descriptor();
             Request_is_known = 1;                 //  
        }
        if ((BD0_Buf[2]== 0) && (BD0_Buf[3]== 2/*Type="Configuration"*/)) {
             //          BD1CNT
             _Put_Configuration_Descriptor();
             //  ,      ! -     9 !
             if (BD0_Buf[6] < BD1CNT) {BD1CNT = BD0_Buf[6]; }
             //
             BD1STAT = 0b11001000;    // UOWN | DTS=DATA1 | DTSEN  - the host may want to have correct DATA0/DATA1 bit
             Request_is_known = 1;                 //  
        }
        if ((BD0_Buf[2]== 0) && (BD0_Buf[3]== 3/*Type="String"*/)) { //      
           //         , Windows-  ,
           //      
           //      :)
             _Put_StringZero_Descriptor();
             Request_is_known = 0;                 //  
        }
        // if ((BD0_Buf[2]== 0) && (BD0_Buf[3]== 6/*Type="Device Qualifier" - Only for high speed capable devices*/)) { }
    }
    if ((BD0_Buf[0] == 0) && (BD0_Buf[1] == 5)) { // && (BD0CNT > 0)) {
        //    "SET_ADDRESS": BD0_Buf[0] = 00000000b; BD0_Buf[1] = 5 = SET_ADDRESS
        // ,    ,   
        //   BD0_Buf[2] = bDevADR;                                //Device Address 0-127
        //   BD0_Buf[3] = bDevADRH;                                //Must equal zero
             NewAddress = BD0_Buf[2];        // remember the address and set UADDR with new address on the next IN transaction (!)
        //     ,       ,
        //       -   
            BD1CNT = 0;
            BD1STAT = 0xC8;           //0b11000000 = UOWN | DTS=DATA | DTSEN
        //  "",   ,     Control Transfer   
        //   .      SIE  __ 
        //   -, .. -     TRNIF    IN
             New_Address_Arrived = 1;           //  "",     SIE  
             Request_is_known = 1;                 //  
    }
    #ifdef EUSART_DEBUG
    if (!Request_is_known) {
         // send unknown packet to PC
         BD0_to_PC();
    }
    #endif
}
//---------------------------------------------------------------------------------------------------------------------------

// must handle: UIR.TRNIF, UIR.URSTIF (Reset)
void USB_Int_Proc(){
     //   UIR:
     //  - SOFIF STALLIF IDLEIF TRNIF ACTVIF UERRIF URSTIF
     //      TRNIF   URSTIF
     if (UIR.TRNIF){ //    
        //  -    :
        //   USTAT.DIR = 0 for SETUP or OUT event, BD0 contains BD0CNT bytes of data  / USTAT.DIR = 1: The last transaction was an IN token
        //   USTAT.(bit 5-3): ENDP<2:0>: Encoded Number of Last Endpoint Activity bits
        //   (/) ,   (bit 5-2) BD0STAT  (   USTAT.DIR)  BD1STAT 
        // PID<3:0>: Packet Identifier bits = The received token PID value of the last transfer (IN, OUT or SETUP transactions only)
        if (!USTAT.F2 /*.DIR*/) {
            Packet_Identifier = (BD0STAT & 0b00111100) >> 2;
        } else  {
            Packet_Identifier = (BD1STAT & 0b00111100) >> 2;
        }
        // send packet ID to PC for debug
        #ifdef EUSART_DEBUG
        while (!PIR1.TXIF) {};      TXREG = Packet_Identifier;
        #endif
        if (!USTAT.F2 /*.DIR*/) {
            //    -    (OUT)
            //   BD0CNT    
            #ifdef EUSART_DEBUG
            asm nop; while (!PIR1.TXIF) {};  TXREG = BD0CNT;
            #endif
            if (Packet_Identifier == 0x0D) {
                  //      SETUP
                  Analyse_SETP_Transaction();
            } else {
                  //      : (simple OUT transaction, including acknowledging OUT-packets)
                  //     ,  -     -  -
                  #ifdef EUSART_DEBUG
                  if (BD0CNT > 0) {
                     BD0_to_PC();
                  }
                  #endif
            }
            //  SIE   -  ,     
            BD0CNT = 64; //
            BD0STAT = 0x80;  //   -   F5  F4 (    )    SIE (.F7(UOWN)=1)
            UCON.PKTDIS = 0; // : Packet Transfer Disable bit; automatically set when a SETUP token is received
        } else {
            //    -    (IN)
            #ifdef EUSART_DEBUG
            asm nop; while (!PIR1.TXIF) {};  TXREG = BD1CNT;
            #endif
            //            for (i=0; i<2/*BD1CNT*/; i++) {  asm nop; while (!PIR1.TXIF) {};  TXREG = BD1_Buf[i]; }
           // After an IN transfer, the SIE will return the number of bytes sent to the host.
              if (New_Address_Arrived) {
                             UADDR = NewAddress;
                             #ifdef EUSART_DEBUG
                             while (!PIR1.TXIF) {};      TXREG = 0x04;
                             #endif
                             New_Address_Arrived = 0; // prevent one more setting
              }
              //     ,       !
              BD1CNT = 0;
              //        
              //       
              //        SIE (,     )
              if (BD1STAT.F6) { BD1STAT = 0x88; /*UOWN | DTS=0 | DTSEN*/} else { BD1STAT = 0xC8; /*UOWN | DTS=1 | DTSEN*/ };
              //        :)
        }
        // !   ,   ,  
        UIR.TRNIF = 0;
     }

     // Reset - indicated by URSTIF
     if (UIR.URSTIF) {
        #ifdef EUSART_DEBUG
        while (!PIR1.TXIF) {};      TXREG = 0x0C;
        while (UIR.TRNIF) UIR.TRNIF = 0;
        #endif
        UCON.PKTDIS = 0;
        Fill_Buffer_Descriptors();
        UIR = 0;           // clear all other interrupt flags!!!
        UADDR = 0;         // UADDR is reset to 00h when a USB Reset is received,
        /*
        //UEP0 = 0;
        UEP0.EPHSHK = 1;   // EP0 handshaking on - Typically, this bit is always set except when using isochronous endpoints.
        UEP0.EPOUTEN = 1;  // EP0 OUT enable
        UEP0.EPINEN = 1;   // EP0 IN enable
        UEP0.EPCONDIS = 0; // EP0 control transfers on; 0 = Enable Endpoint n for control (SETUP) transfers; IN and OUT transfers also allowed
        // re-enable interrupts
        UIE = 0x00; // Disable status interrupts (default=?)
        UIE.TRNIE = 1; // ransaction Complete Interrupt Enable bit
        UIE.URSTIE = 1; // usb reset event  */
        // !   ,   ,  
        UIR.URSTIF = 0;
     };
     // !   ,   ,  
     PIR2.USBIF = 0; // clear usb interrupt flag
}

void interrupt(){
  if (PIR2.USBIF) {
     USB_Int_Proc(); // interrupt from USB module
  }

}


void main() {
//
          New_Address_Arrived = 0;
//
 PORTC = 0;
 ANSEL = 0;   // setup digital I/O
 ANSELH = 0;  // setup digital I/O
 SLRCON = 0;  // setup slew rate
 CM1CON0 = 0; // disable comparator 1
 CM2CON0 = 0; // disable comparator 2
  pin_a0_direction = output;
  pin_a1_direction = output;


 pin_c5_direction = output ;
 PORTC.F5 = 1;
 //
 #ifdef EUSART_DEBUG
 Setup_EUSART_Transmitt();
 #endif
 
 // Configure USB module
 // The USB module has specific clock requirements. For full-speed operation, the clock source must be 48 MHz.
 // USB CONFIGURATION REGISTER (UCFG)
 UCFG = 0b00010100;
 /* UCFG:  UTEYE - - UPUEN x FSEN PPB1 PPB0
    UCFG.UPUEN = 1; // pull-up resistors
    UCFG.FSEN = 1; // 1 = Full-speed device: controls transceiver edge rates; requires input clock at 48 MHz
                  // 0 = Low-speed device: controls transceiver edge rates; requires input clock at 6 MHz  */
 // The on-chip USB pull-up resistors are controlled by the UCFG.UPUEN bit (UCFG<4>).
 //     They can only be selected when the on-chip transceiver is enabled.
 //     The UPUEN, and FSEN bits should never be changed while the USB module is enabled. These values must be preconfigured prior to enabling the module.

 // Configure Endpoints: Each of the 8 possible bidirectional endpoints has its own independent control register, UEPn, n=0...7
 // UEPn: USB ENDPOINT n CONTROL REGISTER (UEP0 THROUGH UEP7)
 // Configure endpoint 0
 UEP0 = 0b00010110;
 /* UEP0:    EPHSHK EPCONDIS EPOUTEN EPINEN EPSTALL
    UEP0.EPHSHK = 1;        // EP0 handshaking on - Typically, this bit is always set except when using isochronous endpoints; required for control transfers
    UEP0.EPOUTEN = 1;        // EP0 OUT enable
    UEP0.EPINEN = 1;         // EP0 IN enable
    UEP0.EPCONDIS = 0;        // EP0 control transfers on; 0 = Enable Endpoint n for control (SETUP) transfers; IN and OUT transfers also allowed  */
 // and disable others enpoints
 UEP1=0; UEP2=0; UEP3=0; UEP4=0; UEP5=0; UEP6=0; UEP7=0;

 // USB ADDRESS REGISTER(UADDR)
 //     The USB address must be written by the microcontroller during the USB setup phase (enumeration)
 // By default, device must responce at address 0
 UADDR = 0;

 // Buffer Descriptor Table (BDT) provides a flexible method to construct and control endpoint buffers
 // Buffer Descriptors (BD) are used to define and control the actual buffers in the USB RAM space:
 // BDnSTAT: BD Status register, BDnCNT: BD Byte Count register, BDnADRL: BD Address Low register, BDnADRH: BD Address High register, n=0..31
 Fill_Buffer_Descriptors();

 // Switch on USB module
// Enabling the USB module (UCON.USBEN = 1) will also enable the internal transceiver.
 UCON = 0b00001000;
 /* UCON:  -  PPBRST  SE0  PKTDIS  USBEN  RESUME  SUSPND  -
    UCON.USBEN = 1;
 */
 while (UCON.SE0) {}; // do nothing until initial SE0 condition clears

 // init USB-accosiated interrupts
 UEIR = 0; // clear USB error interrupt flags
 UEIE = 0; // Disable error interrupts (default=?)
 UIR = 0;  // clear USB interrupt flags

 UIE = 0b00001001; // Disable status interrupts (default=?)
 /* UIE:   SOFIE STALLIE IDLEIE TRNIE ACTVIE UERRIE URSTIE
    UIE.TRNIE = 1; // ransaction Complete Interrupt Enable bit
    UIE.URSTIE = 1; // usb reset event  */

 // All sources are funneled into a single USB interrupt request, USBIF (PIR2<2>), in the microcontrollers interrupt logic.
 PIE2.USBIE = 1;   // Enable interrupt from peripheral USB module
 INTCON.PEIE = 1;  // Enable interrupt from peripheral
 INTCON.GIE = 1;   // Global Interrupt Enable bit

 PORTC.F5 = 0;     // initialization done - switch off the LED

 while (1) {

 };

}